@extends('admin.layout')

@section('content')
<div class="p-6">
    <h1 class="text-xl font-semibold mb-4">Tambah Kategori</h1>

    @if ($errors->any())
        <div class="bg-red-100 text-red-700 p-4 rounded mb-4">
            <ul class="list-disc pl-4">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.kategoris.store') }}" method="POST" class="bg-white p-6 rounded shadow">
        @csrf
        <div class="mb-4">
            <label for="nama" class="block font-semibold mb-1">Nama Kategori</label>
            <input type="text" name="nama" id="nama" class="w-full border border-gray-300 px-4 py-2 rounded" value="{{ old('nama') }}" required>
        </div>
        <div class="flex items-center gap-4">
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Simpan</button>
            <a href="{{ route('admin.kategoris.index') }}" class="text-gray-600 hover:underline">Batal</a>
        </div>
    </form>
</div>
@endsection
