<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rekam_mediks', function (Blueprint $table) {
            $table->id();
            $table->string('nama_pasien');
            $table->integer('umur');
            $table->string('alamat')->nullable();
            $table->text('keluhan')->nullable();
            $table->text('indikasi')->nullable();
            $table->text('penanganan')->nullable();
            $table->unsignedBigInteger('dokter_id');
            $table->foreign('dokter_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger('resep_id')->nullable();
            $table->foreign('resep_id')->references('id')->on('reseps')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rekam_mediks');
    }
};
