<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
            Schema::create('transaksi_items', function (Blueprint $table) {
            $table->id();
            // Relasi ke transaksi utama
            $table->foreignId('transaksi_id')->constrained()->onDelete('cascade');
            // Relasi ke master obat
            $table->foreignId('obat_id')->constrained('master_obats')->onDelete('cascade');
            // Relasi ke pembelian detail (stok batch tertentu, opsional)
            $table->foreignId('pembelian_detail_id')->nullable()->constrained()->onDelete('set null');

            // Backup data penting saat transaksi
            $table->string('nama_obat'); // menyimpan nama obat saat transaksi
            $table->string('satuan')->nullable(); // satuan saat transaksi

            // Data transaksi
            $table->integer('jumlah'); // jumlah yang dijual
            $table->decimal('harga_satuan', 15, 2); // harga jual per item saat transaksi
            $table->decimal('subtotal', 15, 2); // jumlah * harga_satuan

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transaksi_items');
    }
};
