<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TransaksiItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'transaksi_id',
        'obat_id',
        'pembelian_detail_id',
        'nama_obat',
        'satuan',
        'jumlah',
        'harga_satuan',
        'subtotal',
    ];

    public function transaksi()
    {
        return $this->belongsTo(Transaksi::class);
    }

    public function obat()
    {
        return $this->belongsTo(MasterObat::class, 'obat_id');
    }

    public function pembelianDetail()
    {
        return $this->belongsTo(PembelianDetail::class);
    }
}
