<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Transaksi extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'rekam_medik_id','tanggal_transaksi', 'total'];

    protected $casts = [
        'tanggal_transaksi' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(TransaksiItem::class);
    }

    public function masterObat()
    {
        return $this->belongsTo(MasterObat::class, 'master_obat_id');   
    }

    public function rekamMedik()
    {
        return $this->belongsTo(RekamMedik::class, 'rekam_medik_id');
    }
}
