<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resep extends Model
{
    protected $fillable = ['dokter_id', 'kode_resep'];

    public function dokter()
    {
        return $this->belongsTo(User::class, 'dokter_id');
    }
    
    public function resepObats()
    {
        return $this->hasMany(ResepObat::class);
    }

    public function obats()
    {
        return $this->belongsToMany(MasterObat::class, 'resep_obats', 'resep_id', 'obat_id')
                    ->withPivot('jumlah', 'dosis', 'aturan_pakai')
                    ->withTimestamps();
    }


    public function rekamMedik()
    {
        return $this->hasOne(RekamMedik::class, 'resep_id');
    }

}
