<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RekamMedik extends Model
{
    protected $fillable = [
        'nama_pasien',
        'umur',
        'alamat',
        'keluhan',
        'indikasi',
        'penanganan',
        'dokter_id',
        'resep_id',
    ];

    /**
     * Relasi ke tabel users (dokter)
     */
    public function dokter()
    {
        return $this->belongsTo(User::class, 'dokter_id');
    }

    /**
     * Relasi ke tabel reseps
     */
    public function resep()
    {
        return $this->belongsTo(Resep::class, 'resep_id');
    }

    public function transaksi()
    {
        return $this->hasMany(Transaksi::class, 'rekam_medik_id');
    }
}
