<?php

namespace App\Http\Controllers;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

use Illuminate\Http\Request;

class UserController extends Controller
{
    public function login()
    {
        return view('auth.login');
    }

    public function auth(Request $request)
{
    $credentials = $request->only('email', 'password');

    if (Auth::attempt($credentials)) {
        $request->session()->regenerate();

        $role = Auth::user()->role;

        if (!$role) {
            Auth::logout();
            return back()->with('error', 'Login gagal! Role pengguna tidak ditemukan.');
        }

        return match ($role) {
            'admin' => redirect('/admin/dashboard'),
            'dokter' => redirect('/dokter/dashboard'),
            'karyawan' => redirect('/karyawan/dashboard'),
            default => redirect('/login'),
        };
    }

    return back()->with('error', 'Login gagal! Email atau password salah.');
    }

    public function logout(Request $request)
    {
        Auth::logout(); // ✅ Ini yang benar
    $request->session()->invalidate();
    $request->session()->regenerateToken();

    return redirect('/login');
    }
}
