<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Obat;
use App\Models\Resep;
use App\Models\ResepObat;

class ResepObatController extends Controller
{
    public function store(Request $request, $resepId)
{
    $request->validate([
        'obat_id' => 'required|exists:obats,id',
        'dosis' => 'required|string',
        'aturan_pakai' => 'required|string',
    ]);

    ResepObat::create([
        'resep_id' => $resepId,
        'obat_id' => $request->obat_id,
        'dosis' => $request->dosis,
        'aturan_pakai' => $request->aturan_pakai,
    ]);

    return back()->with('success', 'Obat berhasil ditambahkan ke resep.');
}
    public function destroy($id)
    {
        $item = ResepObat::findOrFail($id);
        $item->delete();

        return back()->with('success', 'Obat di resep berhasil dihapus.');
    }

}
