<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Obat;

class KaryawanObatController extends Controller
{
    public function index(Request $request)
    {
        $query = Obat::query();

        if ($request->filled('cari')) {
            $query->where('nama', 'like', '%' . $request->cari . '%');
        }

        $obats = $query->with('kategori') 
                       ->orderBy('nama')
                       ->paginate(10); 
        
        if ($request->ajax()) {
        return view('karyawan.obat.data', compact('obats'))->render();
    }

        return view('karyawan.obat.index', compact('obats'));
    }
}
